/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.mcef.remote;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.montoyo.mcef.MCEF;
import net.montoyo.mcef.client.ClientProxy;
import net.montoyo.mcef.remote.Resource;
import net.montoyo.mcef.remote.ResourceList;
import net.montoyo.mcef.setup.FileListing;
import net.montoyo.mcef.utilities.IProgressListener;
import net.montoyo.mcef.utilities.Log;
import net.montoyo.mcef.utilities.Util2;
import net.montoyo.mcef.utilities.Version;
import org.cef.OS;

public class RemoteConfig {
    private static String PLATFORM;
    private ResourceList resources = new ResourceList();
    private ArrayList<String> extract = new ArrayList();
    private String version = null;

    private JsonObject readConfig(File f) {
        try {
            return new JsonParser().parse((Reader)new FileReader(f)).getAsJsonObject();
        }
        catch (JsonIOException e) {
            Log.error("IOException while reading remote config.", new Object[0]);
            e.printStackTrace();
            return null;
        }
        catch (FileNotFoundException e) {
            Log.error("Couldn't find remote config.", new Object[0]);
            e.printStackTrace();
            return null;
        }
        catch (Exception e) {
            Log.error("Syntax error in remote config.", new Object[0]);
            e.printStackTrace();
            return null;
        }
    }

    private JsonObject readConfig() {
        File newCfg = new File(ClientProxy.JCEF_ROOT, "mcef2.new");
        File cfgFle = new File(ClientProxy.JCEF_ROOT, "mcef2.json");
        boolean ok = Util2.download("config2.json", newCfg, null);
        if (ok) {
            Util2.delete(cfgFle);
            if (newCfg.renameTo(cfgFle)) {
                return this.readConfig(cfgFle);
            }
            Log.warning("Couldn't rename mcef2.new to mcef2.json.", new Object[0]);
            return this.readConfig(newCfg);
        }
        return this.readConfig(cfgFle);
    }

    public void load() {
        JsonElement cVer;
        JsonElement ext;
        String id;
        JsonObject json = this.readConfig();
        if (json == null) {
            Log.error("Could NOT read either remote and local configuration files. Entering virtual mode.", new Object[0]);
            ClientProxy.VIRTUAL = true;
            return;
        }
        if (OS.isWindows()) {
            id = "win";
        } else if (OS.isMacintosh()) {
            id = "mac";
        } else if (OS.isLinux()) {
            id = "linux";
        } else {
            Log.error("Your OS isn't supported by MCEF. Entering virtual mode.", new Object[0]);
            ClientProxy.VIRTUAL = true;
            return;
        }
        String arch = System.getProperty("sun.arch.data.model");
        if (!arch.equals("64")) {
            Log.error("Your CPU arch isn't supported by MCEF. Entering virtual mode.", new Object[0]);
            ClientProxy.VIRTUAL = true;
            return;
        }
        PLATFORM = id + arch;
        Log.info("Detected platform: %s", PLATFORM);
        JsonElement ver = json.get("1.33");
        if (ver == null || !ver.isJsonObject()) {
            Log.error("Config file does NOT contain the latest MCEF version (wtf??). Entering virtual mode.", new Object[0]);
            ClientProxy.VIRTUAL = true;
            return;
        }
        JsonObject vData = ver.getAsJsonObject();
        JsonElement cat = vData.get("platforms");
        if (cat == null || !cat.isJsonObject()) {
            Log.error("Config file is missing \"platforms\" object. Entering virtual mode.", new Object[0]);
            ClientProxy.VIRTUAL = true;
            return;
        }
        JsonObject catObj = cat.getAsJsonObject();
        JsonElement res = catObj.get(PLATFORM);
        if (res == null || !res.isJsonObject()) {
            Log.error("Your platform isn't supported by MCEF yet. Entering virtual mode.", new Object[0]);
            ClientProxy.VIRTUAL = true;
            return;
        }
        this.resources.clear();
        this.addResources(res.getAsJsonObject(), PLATFORM);
        res = catObj.get("shared");
        if (res != null && res.isJsonObject()) {
            this.addResources(res.getAsJsonObject(), "shared");
        }
        if ((ext = vData.get("extract")) != null && ext.isJsonArray()) {
            JsonArray ray = ext.getAsJsonArray();
            for (JsonElement e : ray) {
                if (e == null || !e.isJsonPrimitive()) continue;
                this.extract.add(e.getAsString());
            }
        }
        String actualVersion = String.valueOf(Minecraft.m_91087_().m_91309_().getVersion());
        JsonElement mcVersions = json.get("latestVersions");
        if (mcVersions != null && mcVersions.isJsonObject() && (cVer = mcVersions.getAsJsonObject().get("1.19")) != null && cVer.isJsonPrimitive()) {
            this.version = cVer.getAsString();
        }
    }

    private void addResources(JsonObject res, String pform) {
        Set files = res.entrySet();
        for (Map.Entry e : files) {
            if (e.getValue() == null || !((JsonElement)e.getValue()).isJsonPrimitive()) continue;
            String key = (String)e.getKey();
            if (key.length() >= 2 && key.charAt(0) == '@') {
                Resource eRes = new Resource(key.substring(1), ((JsonElement)e.getValue()).getAsString(), pform);
                eRes.setShouldExtract();
                this.resources.add(eRes);
                continue;
            }
            this.resources.add(new Resource(key, ((JsonElement)e.getValue()).getAsString(), pform));
        }
    }

    public boolean downloadMissing(IProgressListener ipl) {
        if (MCEF.SKIP_UPDATES) {
            Log.warning("NOT downloading resources as specified in the configuration file", new Object[0]);
            return true;
        }
        Log.info("Checking for missing resources...", new Object[0]);
        this.resources.removeExistings();
        if (this.resources.size() > 0) {
            Log.info("Found %d missing resources. Downloading...", this.resources.size());
            for (Resource resource : this.resources) {
                if (resource.download(ipl)) continue;
                return false;
            }
            for (String string : this.extract) {
                Resource res = this.resources.fromFileName(string);
                if (res == null || res.extract(ipl)) continue;
                Log.warning("Couldn't extract %s. MCEF may not work because of this.", string);
            }
            Log.info("Done; all resources were downloaded.", new Object[0]);
        } else {
            Log.info("None are missing. Good.", new Object[0]);
        }
        return true;
    }

    public String getUpdateString() {
        if (this.version == null) {
            return null;
        }
        Version cfg = new Version(this.version);
        Version cur = new Version("1.33");
        if (cfg.isBiggerThan(cur)) {
            return "New MCEF version available. Current: " + cur + ", latest: " + cfg + ".";
        }
        return null;
    }

    public boolean updateFileListing(File configDir, boolean zipOnly) {
        if (this.resources.isEmpty()) {
            return true;
        }
        FileListing fl = new FileListing(configDir);
        if (!fl.load()) {
            Log.warning("Could not load file listing; trying to overwrite...", new Object[0]);
        }
        if (!zipOnly) {
            for (Resource r : this.resources) {
                fl.addFile(ClientProxy.JCEF_ROOT + "/" + r.getFileName());
            }
        }
        boolean allOk = true;
        for (String r : this.extract) {
            File rf = Resource.getLocationOf(r);
            if (!rf.exists() || fl.addZip(rf.getAbsolutePath())) continue;
            allOk = false;
        }
        return fl.save() && allOk;
    }

    public File[] getResourceArray() {
        return (File[])this.resources.stream().map(r -> Resource.getLocationOf(r.getFileName())).toArray(File[]::new);
    }
}

